﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace jPicoFishfinder1._0
{
    struct ChannelSettings
    {
        public bool DCcoupled;
        public Imports.Range range;
        public bool enabled;
    }

    class Pwq
    {
        public Imports.PwqConditions[] conditions;
        public short nConditions;
        public Imports.ThresholdDirection direction;
        public uint lower;
        public uint upper;
        public Imports.PulseWidthType type;

        public Pwq(Imports.PwqConditions[] conditions,
            short nConditions,
            Imports.ThresholdDirection direction,
            uint lower, uint upper,
            Imports.PulseWidthType type)
        {
            this.conditions = conditions;
            this.nConditions = nConditions;
            this.direction = direction;
            this.lower = lower;
            this.upper = upper;
            this.type = type;
        }
    }

    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            
            short handle;
            short status = Imports.OpenUnit(out handle);   //1. Open the oscilloscope
            if (status != 0)
            {
                MessageBox.Show("Unable to open device", "ERROR");
            }
            else 
            {
                Application.Run(new Form1(handle));
//                MessageBox.Show("Close the device?");
                Imports.CloseUnit(handle);   //12. Close the oscilloscope
            }

        }
    }
}
